{
ͻ
 NAME      : TESTSTAR.PAS                                                    
 FUNCTION  : A short utility to demonstrate how to use STARCOMM.EXE...       
 VERSION   : v2.23                                                           
 LANGUAGE  : TURBO PASCAL v4.0 and laters.                                   
 SYNTAX    : (path)> <path_pgm>TESTSTAR [/8]                                 
           : The "/8" option permits to ask for 8 windows. This is usefull   
           : to open an access to any serial port above the COM4:...         
           : This option is ignored if all the ports above COM4: are unknown!
 REMARKS   :  Before using any function from the driver that returns a      
           : boolean, you should check that the driver IS accessible. If not,
           : the returned value would be un-meaningfull and your program     
           : could then reacts in "stranges" ways !                          
           : The easyest method consist in checking once for all that the    
           : driver is present just at the begining of your program execution
           :  The ports initializations, the hand-shaking status, and the   
           : errors working mode are not modified by TESTSTAR.               
 COPYRIGHT : (C)HETRU Fabrice 1991-1996                                      
ͼ
}



                          PROGRAM TestStar;



{$S+}  (* Stack checking............................: YES *)
{$R-}  (* Over-runs check...........................: NO  *)
{$E-}  (* Reals numbers in computations.............: NO  *)
{$B+}  (* Enhanced boolean evaluation...............: YES *)
{$D-}  (* Debug symbols.............................: NO  *)
{$L-}  (* Locals symbols access for debugging.......: NO  *)


USES
  Crt, Dos, StarIntf;


CONST
  { Receipt and transmit windows coordinates. }
  x1_com1:BYTE=02;   y1_com1:BYTE=03;   x2_com1:BYTE=19;   y2_com1:BYTE=16;
  x1_com2:BYTE=22;   y1_com2:BYTE=03;   x2_com2:BYTE=39;   y2_com2:BYTE=16;
  x1_com3:BYTE=42;   y1_com3:BYTE=03;   x2_com3:BYTE=59;   y2_com3:BYTE=16;
  x1_com4:BYTE=62;   y1_com4:BYTE=03;   x2_com4:BYTE=79;   y2_com4:BYTE=16;
  x1_com5:BYTE=02;   y1_com5:BYTE=11;   x2_com5:BYTE=19;   y2_com5:BYTE=16;
  x1_com6:BYTE=22;   y1_com6:BYTE=11;   x2_com6:BYTE=39;   y2_com6:BYTE=16;
  x1_com7:BYTE=42;   y1_com7:BYTE=11;   x2_com7:BYTE=59;   y2_com7:BYTE=16;
  x1_com8:BYTE=62;   y1_com8:BYTE=11;   x2_com8:BYTE=79;   y2_com8:BYTE=16;
  x1_send:BYTE=02;   y1_send:BYTE=19;   x2_send:BYTE=79;   y2_send:BYTE=24;
  { Currents writting positions in the differents used windows. }
  XSend:BYTE = 1;    YSend:BYTE = 1;
  Xcom1:BYTE = 1;    Ycom1:BYTE = 1;
  Xcom2:BYTE = 1;    Ycom2:BYTE = 1;
  Xcom3:BYTE = 1;    Ycom3:BYTE = 1;
  Xcom4:BYTE = 1;    Ycom4:BYTE = 1;
  Xcom5:BYTE = 1;    Ycom5:BYTE = 1;
  Xcom6:BYTE = 1;    Ycom6:BYTE = 1;
  Xcom7:BYTE = 1;    Ycom7:BYTE = 1;
  Xcom8:BYTE = 1;    Ycom8:BYTE = 1;


VAR
  Type_Crt_Mode,
  LastPort,
  SendPort,
  OldSPort,
  error,i       : BYTE                ;
  seg_ecran     : WORD                ;
  VerDrive      : Chn4octets          ;
  PortState     : ARRAY[0..7] OF BYTE ;
  initialise,
  Use8Ports,
  NewEms,
  termine       : BOOLEAN             ;
  Phrase        : STRING[79]          ;
  Eng,Parit,
  StopBit,
  BreakInt      : ARRAY[0..3] OF WORD ;


PROCEDURE WriteCadre(x1,y1,x2,y2:BYTE;c1,c2,c3,c4,c5,c6:CHAR);
  VAR
    i : BYTE ;
  BEGIN
    Window(1,1,80,25);
    GotoXY(x1,y1); WRITE(c1);
    FOR i := 1 TO x2-x1-1 DO WRITE(c2);
    WRITE(c3);
    FOR i := y1+1 TO y2-1 DO
    BEGIN
      GotoXY(x2,i);
      WRITE(c4)
    END;
    GotoXY(x2,y2); WRITE(c5);
    FOR i := x2-1 DOWNTO x1+1 DO
    BEGIN
      GotoXY(i,y2);
      WRITE(c2)
    END;
    GotoXY(x1,y2); WRITE(c6);
    FOR i := y2-1 DOWNTO y1+1 DO
    BEGIN
      GotoXY(x1,i);
      WRITE(c4)
    END;
  END;


PROCEDURE Com_Window(Num: BYTE);
  VAR
    x1_com, y1_com, x2_com, y2_com : BYTE    ;
    SendOK                         : BOOLEAN ;
    NbXoff                         : BYTE    ;
    PBoard, Unused                 : BYTE    ;
    Adresse                        : WORD    ;
  BEGIN
    CASE Num OF
      0: BEGIN
           x1_com:=x1_com1; y1_com:=y1_com1; x2_com:=x2_com1; y2_com:=y2_com1
         END;
      1: BEGIN
           x1_com:=x1_com2; y1_com:=y1_com2; x2_com:=x2_com2; y2_com:=y2_com2
         END;
      2: BEGIN
           x1_com:=x1_com3; y1_com:=y1_com3; x2_com:=x2_com3; y2_com:=y2_com3
         END;
      3: BEGIN
           x1_com:=x1_com4; y1_com:=y1_com4; x2_com:=x2_com4; y2_com:=y2_com4
         END;
      4: BEGIN
           x1_com:=x1_com5; y1_com:=y1_com5; x2_com:=x2_com5; y2_com:=y2_com5
         END;
      5: BEGIN
           x1_com:=x1_com6; y1_com:=y1_com6; x2_com:=x2_com6; y2_com:=y2_com6
         END;
      6: BEGIN
           x1_com:=x1_com7; y1_com:=y1_com7; x2_com:=x2_com7; y2_com:=y2_com7
         END;
      7: BEGIN
           x1_com:=x1_com8; y1_com:=y1_com8; x2_com:=x2_com8; y2_com:=y2_com8
         END;
    END;
    IF PortState[Num] IN [0,8] THEN
    BEGIN
      WriteCadre(x1_com,y1_com,x2_com,y2_com,'','','','','','');
      HighVideo;
      GotoXY(x1_com+1,y1_com); WRITE('COM',Chr(Num+$31),':ems is ');
      CommPort := Num;
      IF Send_SLOW THEN WRITE('slow') ELSE WRITE('fast');
      IF Infos_BoardPort(PBoard,Adresse,Unused,Unused)=0 THEN
      BEGIN
        GotoXY(x1_com+1,y2_com);
        IF PBoard=1 THEN
        BEGIN
          IF XonoffShaking_Status(SendOK,NbXoff) IN [Ord('L'),Ord('B')] THEN
            WRITE('MC')
          ELSE WRITE('multi-comm board');
        END
      END;
      LowVideo;
    END
    ELSE
    BEGIN
      IF PortState[Num]=5 THEN
      BEGIN
        WriteCadre(x1_com,y1_com,x2_com,y2_com,'','','','','','');
        GotoXY(x1_com+1,y2_com+1); WRITE('PORT NOT KNOWN');
      END
      ELSE
      BEGIN
        WriteCadre(x1_com,y1_com,x2_com,y2_com,'','-','','|','','');
        GotoXY(x1_com+1,y2_com+1); WRITE('No more buffers!')
      END;
      GotoXY(x1_com+7,y1_com); WRITE('COM',Chr(Num+$31))
    END;
  END;


PROCEDURE Setup_Screen;
  BEGIN
    ClrScr;
    TextColor(Black); TextBackGround(White);
    GotoXY(1,1); ClrEol;
    GotoXY(18,1); WRITE('TESTSTAR v2.23 for STARCOMM ver ',VerDrive);
    GotoXY(67,1); WRITE('(C)HETRU 1996');
    GotoXY(1,25); ClrEol;
    GotoXY(4,25);
    WRITE('Ctrl-Fi:Transmit COMiF2 testEms->F9:slow F10:fast'+
          'HOME Empty buffersESC');
    TextColor(LightGray); TextBackGround(Black);
    FOR i := 0 TO LastPort DO Com_Window(i);
    WriteCadre(x1_send,y1_send,x2_send,y2_send,'','','','','','');
    HighVideo;
    GotoXY(x1_send+29,y1_send); WRITE('Transmitting on COM1:');
    CommPort := 0;
    LowVideo
  END;


PROCEDURE Status_Port;
VAR
  x_com,y_com : BYTE    ;
  Err_sous_it : BOOLEAN ;
  Buff_ovrfl,
  Engorg,
  Parite_chk,
  SBit,BrkIt  : BYTE    ;
  changements,
  Pret,
  Clear_to_send,
  Sonnerie,
  Porteuse    : BOOLEAN ;
  dDSR, dCTS,
  dRI, dDCD   : BYTE    ;
  Num_Voie    : CHAR    ;
  SendOK      : BOOLEAN ;
  NbXoff      : BYTE    ;
BEGIN
  CASE CommPort OF
    0: BEGIN x_com := x1_com1; y_com := y2_com1; END;
    1: BEGIN x_com := x1_com2; y_com := y2_com2; END;
    2: BEGIN x_com := x1_com3; y_com := y2_com3; END;
    3: BEGIN x_com := x1_com4; y_com := y2_com4; END;
    4: BEGIN x_com := x1_com5; y_com := y2_com5; END;
    5: BEGIN x_com := x1_com6; y_com := y2_com6; END;
    6: BEGIN x_com := x1_com7; y_com := y2_com7; END;
    7: BEGIN x_com := x1_com8; y_com := y2_com8; END
  END;
  (* Link and comms. errors reported by the low level comm. *)
  Err_sous_it := Errors_Report(Buff_ovrfl,Engorg,Parite_chk,SBit,BrkIt);
  IF Err_sous_it THEN
  BEGIN
    Window(1,1,80,25);
    IF Engorg>0 THEN
    BEGIN
      GotoXY(x_com+4,y_com+2);
      WRITE('Over-runs');
      Delay(100);
      GotoXY(x_com+4,y_com+2);
      WRITE('         ');
    END;
    IF Parite_chk>0 THEN
    BEGIN
      GotoXY(x_com+6,y_com+2);
      WRITE('Parity');
      Delay(100);
      GotoXY(x_com+6,y_com+2);
      WRITE('      ');
    END;
    IF SBit>0 THEN
    BEGIN
      GotoXY(x_com+4,y_com+2);
      WRITE('Stop-bits');
      Delay(100);
      GotoXY(x_com+4,y_com+2);
      WRITE('         ');
    END;
    IF BrkIt>0 THEN
    BEGIN
      GotoXY(x_com+7,y_com+2);
      WRITE('BREAK');
      Delay(100);
      GotoXY(x_com+7,y_com+2);
      WRITE('     ');
    END
  END;
  (* Up-dating of the modem status indicators. *)
  Num_Voie := Chr(CommPort+$31);
  Modem_Status(Num_Voie, Pret, Clear_to_send, Sonnerie,
                Porteuse, changements, dDSR, dCTS, dRI, dDCD);
  IF changements OR initialise THEN
  BEGIN
    Window(1,1,80,25);
    GotoXY(x_com+2,y_com+1);
    IF Pret THEN WRITE('DSR')
      ELSE
      BEGIN
        IF dDSR>0 THEN
          BEGIN WRITE('DSR'); GotoXY(x_com+2,y_com+1); Delay(10); END;
        WRITE('dsr')
      END;
    GotoXY(x_com+6,y_com+1);
    IF Clear_to_send THEN WRITE('CTS')
      ELSE
      BEGIN
        IF dCTS>0 THEN
          BEGIN WRITE('CTS'); GotoXY(x_com+6,y_com+1); Delay(10); END;
        WRITE('cts')
      END;
    GotoXY(x_com+10,y_com+1);
    IF Sonnerie THEN WRITE('RI')
      ELSE
      BEGIN
        IF dRI>0 THEN
          BEGIN WRITE('RI'); GotoXY(x_com+10,y_com+1); Delay(10); END;
        WRITE('ri')
      END;
    GotoXY(x_com+13,y_com+1);
    IF Porteuse THEN WRITE('DCD')
      ELSE
      BEGIN
        IF dDCD>0 THEN
          BEGIN WRITE('DCD'); GotoXY(x_com+13,y_com+1); Delay(10); END;
        WRITE('dcd')
      END;
  END;
  (* Informations on the current Xon/Xoff protocol status and working mode. *)
  IF XonoffShaking_Status(SendOK,NbXoff) IN [Ord('L'),Ord('B')] THEN
  BEGIN
    Dec(x_com); Dec(y_com);
    IF SendOK THEN
    BEGIN
      MEM[seg_ecran:2*((80*y_com)+x_com+5)] := Ord('X');
      MEM[seg_ecran:2*((80*y_com)+x_com+6)] := Ord('O');
      MEM[seg_ecran:2*((80*y_com)+x_com+7)] := Ord('N');
      MEM[seg_ecran:2*((80*y_com)+x_com+8)] := Ord('/');
      MEM[seg_ecran:2*((80*y_com)+x_com+9)] := Ord('X');
      MEM[seg_ecran:2*((80*y_com)+x_com+10)] := Ord('o');
      MEM[seg_ecran:2*((80*y_com)+x_com+11)] := Ord('f');
      MEM[seg_ecran:2*((80*y_com)+x_com+12)] := Ord('f');
    END
    ELSE
    BEGIN
      MEM[seg_ecran:2*((80*y_com)+x_com+5)] := Ord('X');
      MEM[seg_ecran:2*((80*y_com)+x_com+6)] := Ord('o');
      MEM[seg_ecran:2*((80*y_com)+x_com+7)] := Ord('n');
      MEM[seg_ecran:2*((80*y_com)+x_com+8)] := Ord('/');
      MEM[seg_ecran:2*((80*y_com)+x_com+9)] := Ord('X');
      MEM[seg_ecran:2*((80*y_com)+x_com+10)] := Ord('O');
      MEM[seg_ecran:2*((80*y_com)+x_com+11)] := Ord('F');
      MEM[seg_ecran:2*((80*y_com)+x_com+12)] := Ord('F')
    END;
  END
END;


PROCEDURE Input_Port;
VAR
  caract     : CHAR ;
  Nb_a_lire,
  Received   : WORD ;
BEGIN
  IF CheckBufferIn(Nb_a_lire) THEN
  BEGIN
    CASE CommPort OF
      0: BEGIN
           Window(x1_com1+1,y1_com1+1,x2_com1-1,y2_com1-1);
           GotoXY(Xcom1,Ycom1)
         END;
      1: BEGIN
           Window(x1_com2+1,y1_com2+1,x2_com2-1,y2_com2-1);
           GotoXY(Xcom2,Ycom2)
         END;
      2: BEGIN
           Window(x1_com3+1,y1_com3+1,x2_com3-1,y2_com3-1);
           GotoXY(Xcom3,Ycom3)
         END;
      3: BEGIN
           Window(x1_com4+1,y1_com4+1,x2_com4-1,y2_com4-1);
           GotoXY(Xcom4,Ycom4)
         END;
      4: BEGIN
           Window(x1_com5+1,y1_com5+1,x2_com5-1,y2_com5-1);
           GotoXY(Xcom5,Ycom5)
         END;
      5: BEGIN
           Window(x1_com6+1,y1_com6+1,x2_com6-1,y2_com6-1);
           GotoXY(Xcom6,Ycom6)
         END;
      6: BEGIN
           Window(x1_com7+1,y1_com7+1,x2_com7-1,y2_com7-1);
           GotoXY(Xcom7,Ycom7)
         END;
      7: BEGIN
           Window(x1_com8+1,y1_com8+1,x2_com8-1,y2_com8-1);
           GotoXY(Xcom8,Ycom8)
         END;
    END;
    REPEAT
      error := ReadSerie(caract,1,Received);
      Dec(Nb_a_lire);
      WRITE(caract);
    UNTIL (Nb_a_lire=0) OR (error<>0);
    CASE CommPort OF
      0: BEGIN Xcom1 := WhereX; Ycom1 := WhereY END;
      1: BEGIN Xcom2 := WhereX; Ycom2 := WhereY END;
      2: BEGIN Xcom3 := WhereX; Ycom3 := WhereY END;
      3: BEGIN Xcom4 := WhereX; Ycom4 := WhereY END;
      4: BEGIN Xcom5 := WhereX; Ycom5 := WhereY END;
      5: BEGIN Xcom6 := WhereX; Ycom6 := WhereY END;
      6: BEGIN Xcom7 := WhereX; Ycom7 := WhereY END;
      7: BEGIN Xcom8 := WhereX; Ycom8 := WhereY END;
    END;
  END
END;


PROCEDURE Output_Port;
VAR
  caract : CHAR ;
  Nb_wr  : WORD ;
  (* Procedure to inform on an error. *)
PROCEDURE Message(message: STRING);
  BEGIN
    Window(1,1,80,25);
    GotoXY(78-Length(message),y2_send);
    WRITE(message); Delay(300);
    GotoXY(78-Length(message),y2_send);
    FOR i:=1 TO Length(message) DO WRITE('')
  END;
  (* End of the error msg procedure. *)
BEGIN
  Window(x1_send+1,y1_send+1,x2_send-1,y2_send-1);
  GotoXY(XSend,YSend);
  IF KeyPressed THEN
  BEGIN
    CommPort := SendPort;
    caract := ReadKey;
    CASE caract OF
      #27: termine := TRUE;
      #0: BEGIN
        IF KeyPressed THEN
        BEGIN
          caract := ReadKey;
          IF LastPort>3 THEN
            CASE caract OF
              #98: BEGIN SendPort := 4; ClrScr END;
              #99: BEGIN SendPort := 5; ClrScr END;
              #100: BEGIN SendPort := 6; ClrScr END;
              #101: BEGIN SendPort := 7; ClrScr END
            END;
          CASE caract OF
            #94: BEGIN SendPort := 0; ClrScr END;
            #95: BEGIN SendPort := 1; ClrScr END;
            #96: BEGIN SendPort := 2; ClrScr END;
            #97: BEGIN SendPort := 3; ClrScr END;
            #60: BEGIN  (* F2 key: Sending the LAZY FOX... test ! *)
                   error := WriteSerie(Phrase[1],Length(Phrase),Nb_wr);
                   IF error=0 THEN WRITE(Phrase)
                     ELSE
                     BEGIN
                       FOR i := 1 TO Nb_wr DO WRITE(Phrase[i]);
                       CASE error OF
                         4: Message('Transmit TIME-OUT');
                         5: Message('Port NOT supported')
                       END;
                     END
                 END;
            #67: IF SLOW_Ems=0 THEN
                 BEGIN
                   Message('SLOW Transm');
                   NewEMS := TRUE
                 END;
            #68: IF FAST_Ems=0 THEN
                 BEGIN
                   Message('FAST Transm');
                   NewEMS := TRUE
                 END;
            #71: BEGIN  (* HOME key:Clear the current window and its buffers *)
                   Purge_buffers;
                   CASE CommPort OF
                     0: BEGIN
                          Window(x1_com1+1,y1_com1+1,x2_com1-1,y2_com1-1);
                          Xcom1 := 1; Ycom1 := 1
                        END;
                     1: BEGIN
                          Window(x1_com2+1,y1_com2+1,x2_com2-1,y2_com2-1);
                          Xcom2 := 1; Ycom2 := 1
                        END;
                     2: BEGIN
                          Window(x1_com3+1,y1_com3+1,x2_com3-1,y2_com3-1);
                          Xcom3 := 1; Ycom3 := 1
                        END;
                     3: BEGIN
                          Window(x1_com4+1,y1_com4+1,x2_com4-1,y2_com4-1);
                          Xcom4 := 1; Ycom4 := 1
                        END;
                     4: BEGIN
                          Window(x1_com5+1,y1_com5+1,x2_com5-1,y2_com5-1);
                          Xcom5 := 1; Ycom5 := 1
                        END;
                     5: BEGIN
                          Window(x1_com6+1,y1_com6+1,x2_com6-1,y2_com6-1);
                          Xcom6 := 1; Ycom6 := 1
                        END;
                     6: BEGIN
                          Window(x1_com7+1,y1_com7+1,x2_com7-1,y2_com7-1);
                          Xcom7 := 1; Ycom7 := 1
                        END;
                     7: BEGIN
                          Window(x1_com8+1,y1_com8+1,x2_com8-1,y2_com8-1);
                          Xcom8 := 1; Ycom8 := 1
                        END;
                   END;
                   ClrScr;
                   Window(x1_send+1,y1_send+1,x2_send-1,y2_send-1); ClrScr
                 END;
            END
          END;
        END;
      ELSE
      BEGIN
        IF caract=#03 THEN error := 0
          ELSE error := WriteSerie(caract,1,Nb_wr);
        CASE error OF
          4: Message('Transmit TIME-OUT');
          5: Message('Port NOT supported');
          ELSE
          BEGIN
            CASE caract OF
              #10: GotoXY(1,WhereY);
              #13: WRITELN;
              #08: WRITE(caract+' '+caract);
              #09: WRITE('       ');
              ELSE WRITE(caract)
            END;
          END
        END;
      END
    END;
    XSend := WhereX; YSend := WhereY;
  END
END;


BEGIN
  CheckBreak := FALSE; (* No Ctrl-Break accepted from the operator. *)
  termine := FALSE;
  initialise := TRUE;
  Use8Ports := FALSE;
  FOR i := 1 TO ParamCount DO
    IF ParamStr(i)='/8' THEN Use8Ports := TRUE;
  Phrase := #10+#13+'The Quick Brown Fox Jumped Over The Lazy Dog''s'+
            + ' Back 0123456789 Times !';
  Type_Crt_Mode := MEM[$40:$49];
  IF NOT (Type_Crt_Mode IN [2,3,7]) THEN TextMode(C80);
  IF MEM[$40:$49]=7 THEN seg_ecran := $B000
    ELSE seg_ecran := $B800;
  SendPort := 0;
  IF type_driver<>0 THEN
  BEGIN
    Version(VerDrive);
    FOR CommPort := 0 TO 7 DO
    BEGIN
      IF Port_Opened THEN BEGIN END;
      PortState[CommPort] := Open_Port
    END;
    LastPort := 3;
    IF Use8Ports THEN
    BEGIN
      IF NOT (ComExist[0] OR ComExist[1] OR ComExist[2] OR ComExist[3] OR
      ComExist[4] OR ComExist[5] OR ComExist[6] OR ComExist[7]) THEN
      BEGIN
        WRITELN('There is NOT even one serial port to use !...');
        Halt(1)
      END;
      IF ComExist[4] OR ComExist[5] OR ComExist[6] OR ComExist[7] THEN
      BEGIN
        y2_com1 := 8; y2_com2 := 8; y2_com3 := 8; y2_com4 := 8;
        LastPort := 7
      END;
    END
    ELSE
      IF NOT (ComExist[0] OR ComExist[1] OR ComExist[2] OR ComExist[3]) THEN
      BEGIN
        WRITELN('There is NOT even one serial port to use !...');
        Halt(1)
      END;
    Setup_Screen;
    REPEAT
      FOR CommPort := 0 TO LastPort DO
      BEGIN
        IF PortState[CommPort] IN [0,8] THEN
        BEGIN
          (* Receive and send errors, hand-shaking status, and modem *)
          (* signals status.                                         *)
          Status_Port;
          (* Serial comm. inputs and information on any comm. error,if any ! *)
          Input_Port
        END;
        IF CommPort=LastPort THEN initialise := FALSE
      END;
      (* Keyboard management to make transmissions. *)
      OldSPort := SendPort;
      NewEms := FALSE;
      Output_Port;
      IF SendPort<>OldSPort THEN
      BEGIN
        Window(1,1,80,25);
        HighVideo;
        GotoXY(x1_send+48,y1_send);
        WRITE(Chr(SendPort+$31));
        LowVideo
      END;
      IF NewEms THEN
      BEGIN
        Window(1,1,80,25);
        HighVideo;
        CASE CommPort OF
          0: GotoXY(x1_com1+13,y1_com1);
          1: GotoXY(x1_com2+13,y1_com2);
          2: GotoXY(x1_com3+13,y1_com3);
          3: GotoXY(x1_com4+13,y1_com4);
          4: GotoXY(x1_com5+13,y1_com5);
          5: GotoXY(x1_com6+13,y1_com6);
          6: GotoXY(x1_com7+13,y1_com7);
          7: GotoXY(x1_com8+13,y1_com8)
        END;
        IF Send_SLOW THEN WRITE('slow') ELSE WRITE('fast');
        LowVideo
      END;
    UNTIL termine;
    Window(1,1,80,25);
    ClrScr;
    GotoXY(1,2);
    WRITELN('TESTSTAR: Simultaneous communication on all the '
      +'accessibles ports.');
    IF type_driver IN [1,2] THEN
      WRITELN('STARCOMM vs ',VerDrive,' manages the asynchronous ports.');
    FOR CommPort := 0 TO LastPort DO
      IF Close_Port(TRUE)=7 THEN
        WRITELN('Port COM',chr(CommPort+$31),' may NOT be closed !');
    FOR CommPort := LastPort+1 TO 7 DO
      IF Close_Port(FALSE)<>0 THEN BEGIN END;
  END
  ELSE
  BEGIN
    WRITELN('TESTSTAR: Simultaneous communication on all the serial ports.');
    WRITELN('Error: STARCOMM.EXE is not installed in memory !')
  END;
END.
